#include <minix/config.h>
#include "const.h"
#if (CHIP == M68000)

!
! Only the registers that are considered scratch by the compiler used
! to compile the kernel are saved. Other registers are saved by the
! prolog generated by the kernel compiler.
!
#ifdef ALCYON
#define FREEREGS d0-d2/a0-a2
#endif
#ifdef ACK
#define FREEREGS d0-d2/a0-a1
#endif

#ifdef ACK
! section definition
	.sect	.text
	.sect	.rom
	.sect	.data
	.sect	.bss
#endif

!
! public labels
!
	.define	_lock
	.define	_unlock
	.define	_restore
	.define	_reboot
	.define	_sizes
#ifdef ACK
	.define	.trpim
	.define	.trppc
#endif

!
! external references
!
	.extern	_clock_handler
	.extern	_held_head
	.extern _k_reenter
	.extern	_proc_ptr
	.extern	_rdy_head
	.extern	_lock_pick_proc
	.extern	_main
	.extern	_none
	.extern	_rupt
	.extern	_trap
	.extern	_timint
	.extern	_dmaint
	.extern	_siaint
	.extern	_aciaint
	.extern	_piaint
	.extern	_iob
	.extern	_sys_call
!	.extern	_end
!	.extern	_edata

!
! offsets into a proc table entry
!
sava6	= 56
savsp	= 60
savpc	= 64
savsr	= 68
savtt	= 77

	.sect	.text
!
! Trap vectors
!
.data2	0,	0,	0,	start,	0x0200,	err,	0x0300,	err
.data2	0x0400,	trp,	0x0500,	trp,	0x0600,	trp,	0x0700,	trp
.data2	0x0800,	trp,	0x0900,	trc,	0x0A00,	trp,	0x0B00,	trp
.data2	0x0C00,	trp,	0x0D00,	trp,	0x0E00,	trp,	0x0F00,	trp
.data2	0x1000,	non,	0x1100,	non,	0x1200,	non,	0x1300,	non
.data2	0x1400,	non,	0x1500,	non,	0x1600,	non,	0,	conf
.data2	0x1800,	int,	0x1900,	int,	0,	hbl,	0x1B00,	int
.data2	0,	vbl,	0x1D00,	int,	0x1E00,	int,	0x1F00,	int
.data2	0,	sys,	0x2100,	trp,	0x2200,	trp,	0x2300,	trp
.data2	0x2400,	trp,	0x2500,	trp,	0x2600,	trp,	0x2700,	trp
.data2	0x2800,	trp,	0x2900,	trp,	0x2A00,	trp,	0x2B00,	trp
.data2	0x2C00,	trp,	0x2D00,	trp,	0x2E00,	trp,	0x2F00,	trp
.data2	0x3000,	non,	0x3100,	non,	0x3200,	non,	0x3300,	non
.data2	0x3400,	non,	0x3500,	non,	0x3600,	non,	0x3700,	non
.data2	0x3800,	non,	0x3900,	non,	0x3A00,	non,	0x3B00,	non
.data2	0x3C00,	non,	0x3D00,	non,	0x3E00,	non,	0x3F00,	non
.data2	0x0000,	pia,	0x0100,	iob,	0x0200,	iob,	0x0300,	iob
.data2	0x0300,	tim,	0x0200,	clk,	0,	acia,	0,	dma
.data2	0x0100,	tim,	0x0300,	sia,	0x0200,	sia,	0x0100,	sia
.data2	0x0000,	sia,	0x0000,	tim,	0x0600,	iob,	0x0700,	iob
.data2	0x5000,	non,	0x5100,	non,	0x5200,	non,	0x5300,	non
.data2	0x5400,	non,	0x5500,	non,	0x5600,	non,	0x5700,	non
.data2	0x5800,	non,	0x5900,	non,	0x5A00,	non,	0x5B00,	non
.data2	0x5C00,	non,	0x5D00,	non,	0x5E00,	non,	0x5F00,	non
.data2	0x6000,	non,	0x6100,	non,	0x6200,	non,	0x6300,	non
.data2	0x6400,	non,	0x6500,	non,	0x6600,	non,	0x6700,	non
.data2	0x6800,	non,	0x6900,	non,	0x6A00,	non,	0x6B00,	non
.data2	0x6C00,	non,	0x6D00,	non,	0x6E00,	non,	0x6F00,	non
.data2	0x7000,	non,	0x7100,	non,	0x7200,	non,	0x7300,	non
.data2	0x7400,	non,	0x7500,	non,	0x7600,	non,	0x7700,	non
.data2	0x7800,	non,	0x7900,	non,	0x7A00,	non,	0x7B00,	non
.data2	0x7C00,	non,	0x7D00,	non,	0x7E00,	non,	0x7F00,	non
.data2	0x8000,	non,	0x8100,	non,	0x8200,	non,	0x8300,	non
.data2	0x8400,	non,	0x8500,	non,	0x8600,	non,	0x8700,	non
.data2	0x8800,	non,	0x8900,	non,	0x8A00,	non,	0x8B00,	non
.data2	0x8C00,	non,	0x8D00,	non,	0x8E00,	non,	0x8F00,	non
.data2	0x9000,	non,	0x9100,	non,	0x9200,	non,	0x9300,	non
.data2	0x9400,	non,	0x9500,	non,	0x9600,	non,	0x9700,	non
.data2	0x9800,	non,	0x9900,	non,	0x9A00,	non,	0x9B00,	non
.data2	0x9C00,	non,	0x9D00,	non,	0x9E00,	non,	0x9F00,	non
.data2	0xA000,	non,	0xA100,	non,	0xA200,	non,	0xA300,	non
.data2	0xA400,	non,	0xA500,	non,	0xA600,	non,	0xA700,	non
.data2	0xA800,	non,	0xA900,	non,	0xAA00,	non,	0xAB00,	non
.data2	0xAC00,	non,	0xAD00,	non,	0xAE00,	non,	0xAF00,	non
.data2	0xB000,	non,	0xB100,	non,	0xB200,	non,	0xB300,	non
.data2	0xB400,	non,	0xB500,	non,	0xB600,	non,	0xB700,	non
.data2	0xB800,	non,	0xB900,	non,	0xBA00,	non,	0xBB00,	non
.data2	0xBC00,	non,	0xBD00,	non,	0xBE00,	non,	0xBF00,	non
.data2	0xC000,	non,	0xC100,	non,	0xC200,	non,	0xC300,	non
.data2	0xC400,	non,	0xC500,	non,	0xC600,	non,	0xC700,	non
.data2	0xC800,	non,	0xC900,	non,	0xCA00,	non,	0xCB00,	non
.data2	0xCC00,	non,	0xCD00,	non,	0xCE00,	non,	0xCF00,	non
.data2	0xD000,	non,	0xD100,	non,	0xD200,	non,	0xD300,	non
.data2	0xD400,	non,	0xD500,	non,	0xD600,	non,	0xD700,	non
.data2	0xD800,	non,	0xD900,	non,	0xDA00,	non,	0xDB00,	non
.data2	0xDC00,	non,	0xDD00,	non,	0xDE00,	non,	0xDF00,	non
.data2	0xE000,	non,	0xE100,	non,	0xE200,	non,	0xE300,	non
.data2	0xE400,	non,	0xE500,	non,	0xE600,	non,	0xE700,	non
.data2	0xE800,	non,	0xE900,	non,	0xEA00,	non,	0xEB00,	non
.data2	0xEC00,	non,	0xED00,	non,	0xEE00,	non,	0xEF00,	non
.data2	0xF000,	non,	0xF100,	non,	0xF200,	non,	0xF300,	non
.data2	0xF400,	non,	0xF500,	non,	0xF600,	non,	0xF700,	non
.data2	0xF800,	non,	0xF900,	non,	0xFA00,	non,	0xFB00,	non
.data2	0xFC00,	non,	0xFD00,	non,	0xFE00,	non,	0xFF00,	non
!
! gap to allow ramdisk to survive
!
	.space	0x0200
!
! startup code, just after interrupt vectors
! clear bss (uninitialized data) section
! call _main and do process switch when it returns
!
start:
!	reset
	move.w	#0x2700,sr
	move.l  #k_stktop,sp	
!	move.l	#_end,d0
!	move.l	#_edata,a0
!	bra	L2
!L1:
!	move.w	#0,(a0)+
!L2:
!	cmp.l	d0,a0
!	bcs	L1
	jsr	_main
	bra	restart

!
! The vector handlers for synchronous traps. save full context.
!
err:
	add.l	#8,sp		! remove extra context
trp:
	bsr	save
	jsr	_trap
	bra	restart
trc:
	btst	#5,(sp)		! tracing through trap?
	beq	trp		! No, do normal trace processing
	rte			! don't trace; execute system call
int:
	bsr	save
	jsr	_rupt
	bra	restart
non:
	bsr	save
	jsr	_none
	bra	restart
sys:
	bsr	save			! d0, d1 and a0 not modified
	move.l	a0,-(sp)		! m_ptr
	move.w	d1,-(sp)		! src_dest
	move.w	d0,-(sp)		! SEND/RECEIVE/BOTH
	move.l	_proc_ptr,a6		! needed to store return value
				! warning: _sys_call may change _proc_ptr
	jsr	_sys_call		! sys_call(func,src_dest,m_ptr)
	move.l  d0,(a6)
	add.l	#8,sp
	bra	restart
!
! The vector handlers for asynchronous traps. context saved only if necessary.
!
iob:
	movem.l	FREEREGS,-(sp)
	move.l	#_iob,a0
	bsr	async
tim:
	movem.l	FREEREGS,-(sp)
	move.l	#_timint,a0
	bsr	async
clk:
	sub.w	#1,clkcnt
	beq	cont
	rte
cont:
	move.w	#4,clkcnt
	movem.l	FREEREGS,-(sp)
	move.l	#_clock_handler,a0
	bsr	async
dma:
	movem.l	FREEREGS,-(sp)
	move.l	#_dmaint,a0
	bsr	async
acia:
	movem.l	FREEREGS,-(sp)
	move.l	#_aciaint,a0
	bsr	async
sia:
	movem.l	FREEREGS,-(sp)
	move.l	#_siaint,a0
	bsr	async
pia:
	movem.l	FREEREGS,-(sp)
	move.l	#_piaint,a0
	bsr	async
!
! The vector handlers that do not affect task switching
!
vbl:
	! currently still enabled, but ignored
	! possibly later something like
	!	movem.l	FREEREGS,-(sp)
	!	move.l	#_vbl,a0
	!	bsr	async
	rte
hbl:
	! must be avoided because it comes so frequent
	! execute spl2()
	or.w	#0x200,sr
	rte
!
! Asynchronous Trap
!
async:
	clr.w	d0			! extract traptype from saved pc
	move.b	(sp)+,d0		! sp incremented by 2
	move.w	d0,(sp)			! push traptype as argument
	add.b	#1,_k_reenter		! from -1 if not reentering
	jsr	(a0)			! call service routine
	tst.w	(sp)+			! pop traptype
	move.w	#0x2700,sr
	sub.b	#1,_k_reenter
	movem.l	(sp)+,FREEREGS
	btst	#5,(sp)			! previously in kernel mode?
				! (interrupted a task or another interrupt)
	bne	L3			! yes: branch and return from interrupt
	cmp.l	#0,_rdy_head+TASK_Q	! any task just readied?
	bne	L4			! yes: branch and do task switch
L3:
	rte
L4:
	bsr	save
	jsr	_lock_pick_proc
	bra	restart
!
! Perform task switch by save and restart
!
save:
	move.w	#0x2700,sr					! ?
	move.l	a6,-(sp)
	move.l	_proc_ptr,a6
	movem.l	d0-d7/a0-a5,(a6)
	move.l	(sp)+,sava6(a6)		! a6
	lea	10(sp),a1
	btst	#5,4(sp)		! test old S-bit
	bne	L5			! jump if S-bit on
	move.l	usp,a1
L5:	move.l	a1,savsp(a6)		! old sp: usp or ksp
	move.b	(sp),savtt(a6)		! trap type
	clr.b	(sp)			! cleanup
	move.l	(sp)+,a1		! return address
	move.w	(sp)+,savsr(a6)		! sr
	move.l	(sp)+,savpc(a6)		! pc
	add.b	#1,_k_reenter		! from -1 if not reentering
	jmp	(a1)

restart:
! Flush any held-up interrupts.
! This reenables interrupts, so the current interrupt handler may reenter.
! This doesn't matter, because the current handler is about to exit and no
! other handlers can reenter since flushing is only done when k_reenter == 0.

	move.w	#0x2700,sr
	tst.b	_k_reenter
	bne	over_call_unhold
	cmp.l	#0,_held_head
	beq	over_call_unhold
	jsr	_unhold
over_call_unhold:
	sub.b	#1,_k_reenter
	jsr	_checksp
	move.l	_proc_ptr,a6
	move.l	savsp(a6),a0		! old sp: usp or ksp
	btst	#5,savsr(a6)		! test old S-bit
	bne	L6			! jump if S-bit on
	move.l	a0,usp
	bra	L7
L6:	move.l	a0,sp
L7:	move.l	savpc(a6),-(sp)		! pc
	move.w	savsr(a6),-(sp)		! sr
	movem.l	(a6),d0-d7/a0-a6
	rte

_lock:
	move.w	sr,d0
	move.w	#0x2700,sr
	rts
_restore:
	move.w	4(sp),sr
	rts
_unlock:
	move.w	#0x2200,sr		! spl2() to block HBL interrupt
	rts
_reboot:
	move.l	4,a0
	jmp	(a0)

	.sect	.data

_sizes:
	.data2	0x526F,0,0,0,0,0,0,0
conf:
	.extern	_proc
	.data4	_proc
	.extern	_keynorm
	.data4	_keynorm
	.extern	_keyshft
	.data4	_keyshft
	.extern	_keycaps
	.data4	_keycaps
	.extern	_font8
	.data4	_font8
	.extern	_font16
	.data4	_font16
	.data4	0

clkcnt: .data2  4

	.space K_STACK_BYTES
k_stktop:

#ifdef ACK
	.sect	.text
	.extern	_write
	.extern	EXIT
_write:
EXIT:
	bra	EXIT

	.sect	.text
.trpim:	.data2	0
.trppc:	.data4	0
#endif ACK

#endif
