#if (CHIP == M68000)
/*
 * Fonts.
 * This driver allows only fonts with a width of 8 bit.
 * This width is implied at various places in the driver. Another width
 * requires code modification. However, font height may vary. There are
 * two built in fonts: one with height 16 and one with height 8.
 * The former can be used for monochrome screens only (25 lines).
 * The latter is standard for color screens (also 25 lines), but
 * may also be used with monochrome screens (50 lines).
 * The fonts are stored as follows:
 *	width =8 is stored in one byte
 *	height =16/8 stored in an array of 16/8 subsequent bytes
 *	128 characters stored as 128 arrays of 16/8 bytes
 * Printable ASCII (0x20 - 0x7e) is indexed by their ASCII code, i.e.
 * the offset between chars is 16/8 bytes.
 * Characters below 0x20 contain other shapes.
 */
#include "kernel.h"

PUBLIC unsigned char font16[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x18,0x3C,0x66,0xC3,0x81,0xE7,0x24,0x24,0x24,0x3C,0x00,0x00,0x00,
0x00,0x00,0x00,0x3C,0x24,0x24,0x24,0xE7,0x81,0xC3,0x66,0x3C,0x18,0x00,0x00,0x00,
0x00,0x00,0x30,0x38,0x2C,0xE6,0x83,0x83,0xE6,0x2C,0x38,0x30,0x00,0x00,0x00,0x00,
0x00,0x00,0x0C,0x1C,0x34,0x67,0xC1,0xC1,0x67,0x34,0x1C,0x0C,0x00,0x00,0x00,0x00,
0x00,0x00,0x7C,0x38,0xBA,0x92,0xD6,0xC6,0xD6,0x92,0xBA,0x38,0x7C,0x00,0x00,0x00,
0x00,0x00,0xFE,0xFE,0xFE,0xFC,0xFC,0xF8,0xFA,0xF2,0xF6,0xE6,0xEE,0x00,0x00,0x00,
0x00,0x00,0xEE,0xC6,0xD6,0x92,0xBA,0x38,0xBA,0x92,0xD6,0xC6,0xEE,0x00,0x00,0x00,
0x00,0x00,0x01,0x01,0x03,0x03,0x06,0x06,0x8C,0x8C,0xD8,0x58,0x70,0x30,0x20,0x00,
0x00,0x00,0x00,0x3C,0x66,0xC3,0x91,0x91,0x9D,0x81,0xC3,0x66,0x3C,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x18,0x3C,0x3C,0x3C,0x3C,0x3C,0x7E,0xFF,0x10,0x38,0x10,0x00,
0x00,0x00,0x08,0x0E,0x0F,0x09,0x08,0x08,0x78,0xF8,0x70,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x78,0x40,0x70,0x40,0x40,0x00,0x1E,0x10,0x1C,0x10,0x10,0x00,0x00,0x00,
0x00,0x00,0x38,0x40,0x40,0x40,0x38,0x00,0x1C,0x12,0x1C,0x14,0x12,0x00,0x00,0x00,
0x00,0x05,0x05,0x05,0x05,0x0D,0x0D,0x1D,0x39,0x79,0x71,0x71,0x61,0x41,0x00,0x00,
0x00,0xA0,0xA0,0xA0,0xA0,0xB0,0xB0,0xB8,0x9C,0x9E,0x8E,0x8E,0x86,0x82,0x00,0x00,
0x00,0x7C,0xBA,0xC6,0xC6,0xC6,0x82,0x00,0x82,0xC6,0xC6,0xC6,0xBA,0x7C,0x00,0x00,
0x00,0x00,0x02,0x06,0x06,0x06,0x02,0x00,0x02,0x06,0x06,0x06,0x02,0x00,0x00,0x00,
0x00,0x7C,0x3A,0x06,0x06,0x06,0x3A,0x7C,0xB8,0xC0,0xC0,0xC0,0xB8,0x7C,0x00,0x00,
0x00,0x7C,0x3A,0x06,0x06,0x06,0x3A,0x7C,0x3A,0x06,0x06,0x06,0x3A,0x7C,0x00,0x00,
0x00,0x00,0x82,0xC6,0xC6,0xC6,0xBA,0x7C,0x3A,0x06,0x06,0x06,0x02,0x00,0x00,0x00,
0x00,0x7C,0xB8,0xC0,0xC0,0xC0,0xB8,0x7C,0x3A,0x06,0x06,0x06,0x3A,0x7C,0x00,0x00,
0x00,0x7C,0xB8,0xC0,0xC0,0xC0,0xB8,0x7C,0xBA,0xC6,0xC6,0xC6,0xBA,0x7C,0x00,0x00,
0x00,0x7C,0xBA,0xC6,0xC6,0xC6,0x82,0x00,0x02,0x06,0x06,0x06,0x02,0x00,0x00,0x00,
0x00,0x7C,0xBA,0xC6,0xC6,0xC6,0xBA,0x7C,0xBA,0xC6,0xC6,0xC6,0xBA,0x7C,0x00,0x00,
0x00,0x7C,0xBA,0xC6,0xC6,0xC6,0xBA,0x7C,0x3A,0x06,0x06,0x06,0x3A,0x7C,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x7C,0x7E,0x06,0x06,0x7E,0x66,0x66,0x7E,0x3C,0x00,0x00,
0x00,0x00,0x78,0x40,0x70,0x40,0x78,0x00,0x0E,0x10,0x0C,0x02,0x1C,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x0F,0x1F,0x18,0x18,0x10,0x1E,0x17,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xF8,0xEC,0x04,0x04,0x04,0x3C,0x54,
0x11,0x0B,0x0D,0x06,0x07,0x2E,0x39,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x04,0x28,0xD8,0x28,0xD0,0x10,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x18,0x18,0x00,0x00,
0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x66,0x66,0xFF,0xFF,0x66,0x66,0xFF,0xFF,0x66,0x66,0x00,0x00,0x00,0x00,
0x18,0x18,0x3E,0x7E,0x60,0x60,0x7C,0x3E,0x06,0x06,0x7E,0x7C,0x18,0x18,0x00,0x00,
0x00,0x00,0x66,0x66,0x6C,0x0C,0x18,0x18,0x30,0x36,0x66,0x66,0x00,0x00,0x00,0x00,
0x38,0x7C,0x6C,0x6C,0x38,0x38,0x70,0x70,0xDE,0xDE,0xCC,0xCC,0xFE,0x76,0x00,0x00,
0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x06,0x0C,0x1C,0x18,0x18,0x18,0x18,0x18,0x18,0x1C,0x0C,0x06,0x00,0x00,
0x00,0x00,0x60,0x30,0x38,0x18,0x18,0x18,0x18,0x18,0x18,0x38,0x30,0x60,0x00,0x00,
0x00,0x00,0x66,0x66,0x3C,0x3C,0xFF,0xFF,0x3C,0x3C,0x66,0x66,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x18,0x18,0x18,0x7E,0x7E,0x18,0x18,0x18,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x18,0x30,0x20,
0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x18,0x00,0x00,
0x00,0x00,0x06,0x06,0x06,0x0C,0x0C,0x18,0x18,0x30,0x30,0x60,0x60,0x60,0x00,0x00,
0x00,0x00,0x3C,0x7E,0x66,0x66,0x66,0x6E,0x76,0x66,0x66,0x66,0x7E,0x3C,0x00,0x00,
0x00,0x00,0x18,0x18,0x38,0x38,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x7E,0x00,0x00,
0x00,0x00,0x3C,0x7E,0x66,0x66,0x0C,0x0C,0x18,0x18,0x30,0x30,0x7E,0x7E,0x00,0x00,
0x00,0x00,0x7E,0x7E,0x0C,0x0C,0x18,0x18,0x0C,0x0C,0x66,0x66,0x7E,0x3C,0x00,0x00,
0x00,0x00,0x0C,0x0C,0x1C,0x1C,0x3C,0x3C,0x6C,0x6C,0x7E,0x7E,0x0C,0x0C,0x00,0x00,
0x00,0x00,0x7E,0x7E,0x60,0x60,0x7C,0x7E,0x06,0x06,0x06,0x66,0x7E,0x3C,0x00,0x00,
0x00,0x00,0x1C,0x3C,0x70,0x60,0x60,0x7C,0x7E,0x66,0x66,0x66,0x7E,0x3C,0x00,0x00,
0x00,0x00,0x7E,0x7E,0x06,0x06,0x0C,0x0C,0x18,0x18,0x30,0x30,0x30,0x30,0x00,0x00,
0x00,0x00,0x3C,0x7E,0x66,0x66,0x3C,0x3C,0x66,0x66,0x66,0x66,0x7E,0x3C,0x00,0x00,
0x00,0x00,0x3C,0x7E,0x66,0x66,0x7E,0x3E,0x06,0x06,0x06,0x0E,0x3C,0x38,0x00,0x00,
0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x18,0x00,0x00,0x18,0x18,0x18,0x18,0x00,0x00,
0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x18,0x00,0x00,0x18,0x18,0x18,0x18,0x30,0x20,
0x00,0x00,0x00,0x0E,0x1C,0x38,0x70,0xE0,0x70,0x38,0x1C,0x0E,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x7E,0x7E,0x00,0x00,0x7E,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xE0,0x70,0x38,0x1C,0x0E,0x1C,0x38,0x70,0xE0,0x00,0x00,0x00,0x00,
0x00,0x00,0x3C,0x7E,0x66,0x66,0x0C,0x0C,0x18,0x18,0x18,0x00,0x18,0x18,0x00,0x00,
0x00,0x00,0x38,0x7C,0xE6,0xC2,0xDA,0xD6,0xD6,0xDC,0xC0,0xE2,0x7E,0x3C,0x00,0x00,
0x00,0x00,0x18,0x3C,0x7E,0x66,0x66,0x66,0x7E,0x7E,0x66,0x66,0x66,0x66,0x00,0x00,
0x00,0x00,0x7C,0x7E,0x66,0x66,0x7E,0x7C,0x66,0x66,0x66,0x66,0x7E,0x7C,0x00,0x00,
0x00,0x00,0x3C,0x7E,0x66,0x66,0x60,0x60,0x60,0x60,0x66,0x66,0x7E,0x3C,0x00,0x00,
0x00,0x00,0x78,0x7C,0x6E,0x66,0x66,0x66,0x66,0x66,0x66,0x6E,0x7C,0x78,0x00,0x00,
0x00,0x00,0x7E,0x7E,0x60,0x60,0x7C,0x7C,0x60,0x60,0x60,0x60,0x7E,0x7E,0x00,0x00,
0x00,0x00,0x7E,0x7E,0x60,0x60,0x7C,0x7C,0x60,0x60,0x60,0x60,0x60,0x60,0x00,0x00,
0x00,0x00,0x3E,0x7E,0x60,0x60,0x6E,0x6E,0x66,0x66,0x66,0x66,0x7E,0x3C,0x00,0x00,
0x00,0x00,0x66,0x66,0x66,0x66,0x7E,0x7E,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x00,
0x00,0x00,0x7E,0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x7E,0x7E,0x00,0x00,
0x00,0x00,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x66,0x66,0x7E,0x3C,0x00,0x00,
0x00,0x00,0xCC,0xCC,0xD8,0xD8,0xF0,0xF0,0xD8,0xD8,0xCC,0xCC,0xC6,0xC6,0x00,0x00,
0x00,0x00,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x7E,0x7E,0x00,0x00,
0x00,0x00,0xC6,0xC6,0xEE,0xEE,0xFE,0xD6,0xD6,0xC6,0xC6,0xC6,0xC6,0xC6,0x00,0x00,
0x00,0x00,0x66,0x66,0x66,0x76,0x76,0x7E,0x7E,0x6E,0x6E,0x66,0x66,0x66,0x00,0x00,
0x00,0x00,0x3C,0x7E,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x7E,0x3C,0x00,0x00,
0x00,0x00,0x7C,0x7E,0x66,0x66,0x66,0x66,0x7E,0x7C,0x60,0x60,0x60,0x60,0x00,0x00,
0x00,0x00,0x3C,0x7E,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x6A,0x7C,0x36,0x00,0x00,
0x00,0x00,0xF8,0xFC,0xCC,0xCC,0xCC,0xFC,0xF8,0xD8,0xCC,0xCC,0xC6,0xC6,0x00,0x00,
0x00,0x00,0x3E,0x7E,0x60,0x60,0x70,0x38,0x1C,0x0E,0x06,0x06,0x7E,0x7C,0x00,0x00,
0x00,0x00,0x7E,0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,
0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x7E,0x3C,0x00,0x00,
0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x3C,0x3C,0x18,0x18,0x00,0x00,
0x00,0x00,0xC6,0xC6,0xC6,0xC6,0xC6,0xD6,0xD6,0xFE,0xFE,0xEE,0xC6,0x82,0x00,0x00,
0x00,0x00,0x66,0x66,0x66,0x3C,0x3C,0x18,0x18,0x3C,0x3C,0x66,0x66,0x66,0x00,0x00,
0x00,0x00,0x66,0x66,0x66,0x66,0x3C,0x3C,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,
0x00,0x00,0x7E,0x7E,0x0C,0x0C,0x18,0x18,0x30,0x30,0x60,0x60,0x7E,0x7E,0x00,0x00,
0x00,0x00,0x1E,0x1E,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x1E,0x1E,0x00,0x00,
0x00,0x00,0x60,0x60,0x60,0x30,0x30,0x18,0x18,0x0C,0x0C,0x06,0x06,0x06,0x00,0x00,
0x00,0x00,0x78,0x78,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x78,0x78,0x00,0x00,
0x00,0x10,0x10,0x38,0x38,0x6C,0x6C,0xC6,0xC6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFE,0x00,0x00,
0x40,0x60,0x70,0x38,0x1C,0x0C,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3C,0x3E,0x06,0x3E,0x7E,0x66,0x66,0x7E,0x3E,0x00,0x00,
0x00,0x00,0x60,0x60,0x60,0x7C,0x7E,0x66,0x66,0x66,0x66,0x66,0x7E,0x7C,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3C,0x7C,0x60,0x60,0x60,0x60,0x60,0x7E,0x3E,0x00,0x00,
0x00,0x00,0x06,0x06,0x06,0x3E,0x7E,0x66,0x66,0x66,0x66,0x66,0x7E,0x3E,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3C,0x7E,0x66,0x66,0x7E,0x60,0x60,0x7E,0x3E,0x00,0x00,
0x00,0x00,0x0E,0x1E,0x18,0x18,0x7E,0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3E,0x7E,0x66,0x66,0x66,0x66,0x7E,0x3E,0x06,0x7E,0x7C,
0x00,0x00,0x60,0x60,0x60,0x7C,0x7E,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x00,
0x00,0x00,0x18,0x18,0x00,0x38,0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x3C,0x00,0x00,
0x00,0x00,0x0C,0x0C,0x00,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x7C,0x78,
0x00,0x00,0xC0,0xC0,0xC0,0xCC,0xDC,0xF8,0xF0,0xF8,0xD8,0xCC,0xCE,0xC6,0x00,0x00,
0x00,0x00,0x38,0x38,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3C,0x3C,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x6C,0xFE,0xFE,0xD6,0xD6,0xD6,0xC6,0xC6,0xC6,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3C,0x7E,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3C,0x7E,0x66,0x66,0x66,0x66,0x66,0x7E,0x3C,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x7C,0x7E,0x66,0x66,0x66,0x66,0x66,0x7E,0x7C,0x60,0x60,
0x00,0x00,0x00,0x00,0x00,0x3E,0x7E,0x66,0x66,0x66,0x66,0x66,0x7E,0x3E,0x06,0x06,
0x00,0x00,0x00,0x00,0x00,0x7C,0x7E,0x66,0x60,0x60,0x60,0x60,0x60,0x60,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3E,0x7E,0x60,0x70,0x3C,0x0E,0x06,0x7E,0x7C,0x00,0x00,
0x00,0x00,0x00,0x18,0x18,0x7E,0x7E,0x18,0x18,0x18,0x18,0x18,0x1E,0x0E,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x7E,0x3E,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x3C,0x3C,0x18,0x18,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xC6,0xC6,0xD6,0xD6,0xFE,0xFE,0xEE,0xC6,0x82,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x66,0x66,0x3C,0x3C,0x18,0x3C,0x3C,0x66,0x66,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x66,0x66,0x66,0x66,0x66,0x66,0x7E,0x3E,0x06,0x7E,0x7C,
0x00,0x00,0x00,0x00,0x00,0x7E,0x7E,0x0C,0x18,0x18,0x30,0x30,0x7E,0x7E,0x00,0x00,
0x00,0x0E,0x18,0x18,0x18,0x18,0x38,0xF0,0xF0,0x38,0x18,0x18,0x18,0x18,0x0E,0x00,
0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,
0x00,0xE0,0x30,0x30,0x30,0x30,0x38,0x1E,0x1E,0x38,0x30,0x30,0x30,0x30,0xE0,0x00,
0x00,0x00,0x00,0x00,0x00,0x62,0xF2,0xBE,0x9C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x3C,0x24,0x66,0x42,0xC3,0xFF,0x00,0x00,0x00,
};

PUBLIC unsigned char font8[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x18,0x3C,0x66,0xC3,0xE7,0x24,0x24,0x3C,
0x3C,0x24,0x24,0xE7,0xC3,0x66,0x3C,0x18,
0x18,0x1C,0xF6,0x83,0x83,0xF6,0x1C,0x18,
0x18,0x38,0x6F,0xC1,0xC1,0x6F,0x38,0x18,
0x3C,0x99,0xC3,0xE7,0xC3,0x99,0x3C,0x00,
0xFF,0xFF,0xFE,0xFC,0xF9,0xF3,0xE7,0x00,
0xE7,0xC3,0x99,0x3C,0x99,0xC3,0xE7,0x00,
0x01,0x03,0x06,0x8C,0xD8,0x70,0x20,0x00,
0x7E,0xC3,0xD3,0xD3,0xDB,0xC3,0xC3,0x7E,
0x18,0x3C,0x3C,0x3C,0x7E,0x10,0x38,0x10,
0x18,0x1C,0x16,0x10,0x10,0x70,0xF0,0x60,
0xF0,0xC0,0xFE,0xD8,0xDE,0x18,0x18,0x00,
0xF0,0xC0,0xDF,0xDB,0xFF,0x1E,0x1B,0x00,
0x05,0x05,0x05,0x0D,0x0D,0x19,0x79,0x71,
0xA0,0xA0,0xA0,0xB0,0xB0,0x98,0x9E,0x8E,
0x7C,0xC6,0xC6,0x00,0xC6,0xC6,0x7C,0x00,
0x06,0x06,0x06,0x00,0x06,0x06,0x06,0x00,
0x7C,0x06,0x06,0x7C,0xC0,0xC0,0x7C,0x00,
0x7C,0x06,0x06,0x7C,0x06,0x06,0x7C,0x00,
0xC6,0xC6,0xC6,0x7C,0x06,0x06,0x06,0x00,
0x7C,0xC0,0xC0,0x7C,0x06,0x06,0x7C,0x00,
0x7C,0xC0,0xC0,0x7C,0xC6,0xC6,0x7C,0x00,
0x7C,0x06,0x06,0x00,0x06,0x06,0x06,0x00,
0x7C,0xC6,0xC6,0x7C,0xC6,0xC6,0x7C,0x00,
0x7C,0xC6,0xC6,0x7C,0x06,0x06,0x7C,0x00,
0x00,0x00,0x3C,0x06,0x7E,0x66,0x3C,0x00,
0x78,0x60,0x78,0x60,0x7E,0x18,0x1E,0x00,
0x07,0x0F,0x1F,0x18,0x18,0x10,0x1E,0x17,
0xF0,0xF8,0xEC,0x04,0x04,0x04,0x3C,0x54,
0x11,0x0B,0x0D,0x06,0x07,0x2E,0x39,0x38,
0x04,0x28,0xD8,0x28,0xD0,0x10,0xE0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x18,0x18,0x18,0x18,0x18,0x00,0x18,0x00,
0x66,0x66,0x66,0x00,0x00,0x00,0x00,0x00,
0x00,0x6C,0xFE,0x6C,0x6C,0xFE,0x6C,0x00,
0x18,0x3E,0x60,0x3C,0x06,0x7C,0x18,0x00,
0x00,0x66,0x6C,0x18,0x30,0x66,0x46,0x00,
0x38,0x6C,0x38,0x70,0xDE,0xCC,0x76,0x00,
0x18,0x18,0x18,0x00,0x00,0x00,0x00,0x00,
0x0E,0x1C,0x18,0x18,0x18,0x1C,0x0E,0x00,
0x70,0x38,0x18,0x18,0x18,0x38,0x70,0x00,
0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00,
0x00,0x18,0x18,0x7E,0x18,0x18,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x60,
0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,
0x02,0x06,0x0C,0x18,0x30,0x60,0x40,0x00,
0x3C,0x66,0x6E,0x76,0x66,0x66,0x3C,0x00,
0x18,0x38,0x18,0x18,0x18,0x18,0x7E,0x00,
0x3C,0x66,0x06,0x0C,0x18,0x30,0x7E,0x00,
0x7E,0x0C,0x18,0x0C,0x06,0x66,0x3C,0x00,
0x0C,0x1C,0x3C,0x6C,0x7E,0x0C,0x0C,0x00,
0x7E,0x60,0x7C,0x06,0x06,0x66,0x3C,0x00,
0x3C,0x60,0x60,0x7C,0x66,0x66,0x3C,0x00,
0x7E,0x06,0x0C,0x18,0x30,0x30,0x30,0x00,
0x3C,0x66,0x66,0x3C,0x66,0x66,0x3C,0x00,
0x3C,0x66,0x66,0x3E,0x06,0x0C,0x38,0x00,
0x00,0x18,0x18,0x00,0x18,0x18,0x00,0x00,
0x00,0x18,0x18,0x00,0x18,0x18,0x30,0x00,
0x06,0x0C,0x18,0x30,0x18,0x0C,0x06,0x00,
0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,
0x60,0x30,0x18,0x0C,0x18,0x30,0x60,0x00,
0x3C,0x66,0x06,0x0C,0x18,0x00,0x18,0x00,
0x3C,0x66,0x6E,0x6A,0x6E,0x60,0x3E,0x00,
0x18,0x3C,0x66,0x66,0x7E,0x66,0x66,0x00,
0x7C,0x66,0x66,0x7C,0x66,0x66,0x7C,0x00,
0x3C,0x66,0x60,0x60,0x60,0x66,0x3C,0x00,
0x78,0x6C,0x66,0x66,0x66,0x6C,0x78,0x00,
0x7E,0x60,0x60,0x7C,0x60,0x60,0x7E,0x00,
0x7E,0x60,0x60,0x7C,0x60,0x60,0x60,0x00,
0x3E,0x60,0x60,0x6E,0x66,0x66,0x3E,0x00,
0x66,0x66,0x66,0x7E,0x66,0x66,0x66,0x00,
0x3C,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,
0x06,0x06,0x06,0x06,0x06,0x66,0x3C,0x00,
0x66,0x6C,0x78,0x70,0x78,0x6C,0x66,0x00,
0x60,0x60,0x60,0x60,0x60,0x60,0x7E,0x00,
0xC6,0xEE,0xFE,0xD6,0xC6,0xC6,0xC6,0x00,
0x66,0x76,0x7E,0x7E,0x6E,0x66,0x66,0x00,
0x3C,0x66,0x66,0x66,0x66,0x66,0x3C,0x00,
0x7C,0x66,0x66,0x7C,0x60,0x60,0x60,0x00,
0x3C,0x66,0x66,0x66,0x76,0x6C,0x36,0x00,
0x7C,0x66,0x66,0x7C,0x6C,0x66,0x66,0x00,
0x3C,0x66,0x60,0x3C,0x06,0x66,0x3C,0x00,
0x7E,0x18,0x18,0x18,0x18,0x18,0x18,0x00,
0x66,0x66,0x66,0x66,0x66,0x66,0x3E,0x00,
0x66,0x66,0x66,0x66,0x66,0x3C,0x18,0x00,
0xC6,0xC6,0xC6,0xD6,0xFE,0xEE,0xC6,0x00,
0x66,0x66,0x3C,0x18,0x3C,0x66,0x66,0x00,
0x66,0x66,0x66,0x3C,0x18,0x18,0x18,0x00,
0x7E,0x06,0x0C,0x18,0x30,0x60,0x7E,0x00,
0x1E,0x18,0x18,0x18,0x18,0x18,0x1E,0x00,
0x40,0x60,0x30,0x18,0x0C,0x06,0x02,0x00,
0x78,0x18,0x18,0x18,0x18,0x18,0x78,0x00,
0x10,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,
0x00,0xC0,0x60,0x30,0x00,0x00,0x00,0x00,
0x00,0x00,0x3C,0x06,0x3E,0x66,0x3E,0x00,
0x60,0x60,0x7C,0x66,0x66,0x66,0x7C,0x00,
0x00,0x00,0x3C,0x60,0x60,0x60,0x3C,0x00,
0x06,0x06,0x3E,0x66,0x66,0x66,0x3E,0x00,
0x00,0x00,0x3C,0x66,0x7E,0x60,0x3C,0x00,
0x1C,0x30,0x7C,0x30,0x30,0x30,0x30,0x00,
0x00,0x00,0x3E,0x66,0x66,0x3E,0x06,0x7C,
0x60,0x60,0x7C,0x66,0x66,0x66,0x66,0x00,
0x18,0x00,0x38,0x18,0x18,0x18,0x3C,0x00,
0x18,0x00,0x18,0x18,0x18,0x18,0x18,0x70,
0x60,0x60,0x66,0x6C,0x78,0x6C,0x66,0x00,
0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00,
0x00,0x00,0xEC,0xFE,0xD6,0xC6,0xC6,0x00,
0x00,0x00,0x7C,0x66,0x66,0x66,0x66,0x00,
0x00,0x00,0x3C,0x66,0x66,0x66,0x3C,0x00,
0x00,0x00,0x7C,0x66,0x66,0x66,0x7C,0x60,
0x00,0x00,0x3E,0x66,0x66,0x66,0x3E,0x06,
0x00,0x00,0x7C,0x66,0x60,0x60,0x60,0x00,
0x00,0x00,0x3E,0x60,0x3C,0x06,0x7C,0x00,
0x00,0x18,0x7E,0x18,0x18,0x18,0x0E,0x00,
0x00,0x00,0x66,0x66,0x66,0x66,0x3E,0x00,
0x00,0x00,0x66,0x66,0x66,0x3C,0x18,0x00,
0x00,0x00,0xC6,0xC6,0xD6,0x7C,0x6C,0x00,
0x00,0x00,0x66,0x3C,0x18,0x3C,0x66,0x00,
0x00,0x00,0x66,0x66,0x66,0x3E,0x06,0x7C,
0x00,0x00,0x7E,0x0C,0x18,0x30,0x7E,0x00,
0x0E,0x18,0x18,0x30,0x18,0x18,0x0E,0x00,
0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
0x70,0x18,0x18,0x0C,0x18,0x18,0x70,0x00,
0x00,0x60,0xF2,0x9E,0x0C,0x00,0x00,0x00,
0x00,0x18,0x18,0x34,0x34,0x62,0x7E,0x00,
};
#endif
