/****************************************************************/
/*								*/
/*	de.h							*/
/*								*/
/*		Definitions for the "Disk editor".		*/
/*								*/
/****************************************************************/
/*  origination         1989-Jan-15        Terrence W. Holm	*/
/****************************************************************/


/****************************************************************/
/*								*/
/*	de(1)							*/
/*								*/
/*  This is the MINIX disk editor. It allows the user to	*/
/*  observe and modify a file system. It can also be used	*/
/*  to recover unlink(2)'ed files				*/
/*								*/
/*  See the de(1) man page.					*/
/*								*/
/****************************************************************/


/****************************************************************/
/*								*/
/*	de		   Copyright  Terrence W. Holm  1989	*/
/*								*/
/* This program was written for users of the Minix operating	*/
/* system, and in the spirit of other public domain software	*/
/* written for said system, this source code is made available	*/
/* at no cost to everyone. I assume no responsibility for	*/
/* damage to file systems caused by this program.		*/
/*								*/
/* This program (one .h, five .c's and a "man" page) may be	*/
/* copied and/or modified subject to (1) no charge must be	*/
/* made for distribution, other than for the medium, (2) all	*/
/* modified sources must be clearly marked as such, (3) all	*/
/* sources must carry this copyright.				*/
/*								*/
/****************************************************************/


/****************************************************************/
/*								*/
/*	files							*/
/*								*/
/*	    de.h		Definitions			*/
/*	    de.c		The main loop			*/
/*	    de_stdin.c		Character input routines	*/
/*	    de_stdout.c		Output routines			*/
/*	    de_diskio.c		File system read/write		*/
/*	    de_recover.c	File restoration routines	*/
/*								*/
/*	    de.1		"Man" page			*/
/*	    Makefile		For "make"			*/
/*	    README		Installation help		*/
/*								*/
/*								*/
/*	fs/path.c was modified to support the 'x' command.	*/
/*	fs/link.c and fs/open.c were changed for 'X'.		*/
/*								*/
/****************************************************************/


/*  General constants  */

#define   MAX_STRING	60		/*  For all input lines	*/
#define   MAX_PREV	8		/*  For 'p' command	*/
#define   SEARCH_BUFFER (4*K)		/*  For '/' and 'n'	*/


/*  Files  */

#define   TMP      "/tmp"		/*  For "-r" output	*/
#define   DEV	   "/dev"		/*  Where devices are	*/


/*  a.out header constants  (see a.out.h, if you have it)  */

#if (CHIP == INTEL)
#define   A_OUT    0x0301
#define   SPLIT    0x0420
#endif

#if (CHIP == M68000)
#define   A_OUT    0x0301
#define   SPLIT	   0x0B20
#endif


/*  Each buffer is 1k.  In WORD mode 16 words (32 bytes) can be	*/
/*  displayed at once. In BLOCK mode 1K bytes can be displayed.	*/
/*  In MAP mode 2048 bits (256 bytes) are displayed.		*/

#define   K		1024		/*  STD_BLK		*/
#define   K_MASK	(~(K-1))	/*  Round to K boundary	*/
#define   K_SHIFT	10		/*  Ie. 1<<10 = K	*/
#define   PAGE_MASK	0x1f		/*  Word mode: 32 bytes	*/
#define   PAGE_SHIFT    5		/*  Ie. 1<<5 = 32	*/
#define   MAP_BITS_PER_BLOCK (8 * K)    /*  1k block, 8192 bits */
#define   MAP_MASK	0xff		/*  256 bytes/screen	*/



/*  Terminal i/o codes  */

#define   CTRL_D	'\004'		/*  ASCII ^D		*/
#define   BELL		'\007'		/*  ASCII bell code     */
#define   BS		'\010'		/*  ASCII back space	*/
#define   CTRL_U	'\025'		/*  ASCII ^U		*/
#define	  ESCAPE  	'\033'		/*  ASCII escape code	*/
#define   DEL           '\177'		/*  ASCII delete code   */


/*  Input escape codes generated by the	Minix console.	*/
/*  Format: ESC [ X. 					*/

#define   ESC_HOME	('H' + 0x80)
#define   ESC_UP	('A' + 0x80)
#define   ESC_PGUP	('V' + 0x80)
#define   ESC_LEFT	('D' + 0x80)
#define   ESC_5		('G' + 0x80)
#define   ESC_RIGHT	('C' + 0x80)
#define   ESC_END	('Y' + 0x80)
#define   ESC_DOWN	('B' + 0x80)
#define   ESC_PGDN	('U' + 0x80)
#define   ESC_PLUS	('T' + 0x80)
#define   ESC_MINUS	('S' + 0x80)


/*  Graphic box codes - only applicable for console display  */
/*  in visual mode "map".				     */

#if (CHIP == INTEL)
#define   BOX_CLR	' '		/*  Empty box		*/
#define   BOX_ALL	'\333'		/*  Filled box		*/
#define   BOX_TOP	'\337'		/*  Filled upper half	*/
#define   BOX_BOT	'\334'		/*  Filled lower half   */
#endif

#if (CHIP == M68000)
/*  Please change these.  */
#define   BOX_CLR	' '		/*  Empty box		*/
#define   BOX_ALL	'='		/*  Filled box		*/
#define   BOX_TOP	'-'		/*  Filled upper half	*/
#define   BOX_BOT	'_'		/*  Filled lower half   */
#endif


/*  Move positions for the output display.  */

#define   STATUS_COLUMN	 2
#define   STATUS_LINE    0
#define   BLOCK_COLUMN	 4
#define   BLOCK_LINE	 4
#define   INFO_COLUMN	 30
#define   INFO_LINE	 BLOCK_LINE
#define   PROMPT_COLUMN	 0
#define   PROMPT_LINE	 23
#define   WARNING_COLUMN 10
#define   WARNING_LINE   10



/*  Values returned by Process() and Get_Filename()  */

#define   OK		  0		/*  No update required	*/
#define   REDRAW	  1		/*  Redraw whole screen	*/
#define   REDRAW_POINTERS 2		/*  Redraw just ptrs	*/
#define   ERROR		  3		/*  Beep		*/


/*  Visual modes  */

#define   WORD	   1
#define   BLOCK    2
#define   MAP	   3


typedef  struct  de_state		/*  State of disk ed.	*/
  {
  /*  Information from super block  */

  unsigned inodes;			/*  Number of i-nodes	*/
  unsigned zones;			/*  Total # of blocks	*/
  unsigned inode_maps;			/*  I-node map blocks	*/
  unsigned zone_maps;			/*  Zone map blocks	*/
  unsigned inode_blocks;		/*  I-node blocks	*/
  unsigned first_data;			/*  Total non-data blks	*/

  unsigned inodes_in_map;		/*  Bits in i-node map	*/
  unsigned zones_in_map;		/*  Bits in zone map	*/

  /*  Information from map blocks  */

  char inode_map[ I_MAP_SLOTS * K ];
  char zone_map[ ZMAP_SLOTS * K ];

  /*  Information for current block  */

  off_t address;			/*  Current address	*/
  off_t last_addr;			/*  For erasing ptrs	*/
  unsigned block;			/*  Current block (1K)	*/
  unsigned offset;			/*  Offset within block	*/

  char buffer[ K ];

  /*  Display state  */

  int  mode;				/*  WORD, BLOCK or MAP	*/
  int  output_base;			/*  2, 8, 10, or 16	*/

  /*  Search information  */

  char search_string[ MAX_STRING + 1 ];	/*  For '/' and 'n'	*/
  off_t prev_addr[ MAX_PREV ];		/*  For 'p' command	*/
  int   prev_mode[ MAX_PREV ];

  /*  File information  */

  char *device_name;			/*  From command line	*/
  int   device_d;
  int   device_mode;			/*  O_RDONLY or O_RDWR	*/
  unsigned device_size;			/*  Number of blocks	*/

  char  file_name[ MAX_STRING + 1 ];	/*  For 'w' and 'W'	*/
  FILE *file_f;
  int   file_written;			/*  Flag if written to	*/

  }  de_state;



/*  Forward references for external routines  */

/*  libc.a  */

struct passwd *getpwuid();
struct group *getgrgid();
char *ctime();
char *getenv();
char *tgetstr();
char *tgoto();
char *ttyname();
FILE *fopen();
off_t lseek();


/*  de.c  */

void  main();
int   Process();

void  Push();
int   Get_Filename();
int   Get_Count();
int   Str_Int();
int   In_Use();
ino_t Find_Inode();
void  Exec_Shell();
void  Sigint();
void  Error();


/*  de_stdin.c  */

void  Save_Term();
void  Set_Term();
void  Reset_Term();
int   Get_Char();
char *Get_Line();
int   Arrow_Esc();


/*  de_stdout.c  */

int   Init_Termcap();
void  Goto();
void  Draw_Help_Screen();
void  Wait_For_Key();
void  Draw_Prompt();
void  Erase_Prompt();

void  Draw_Screen();
void  Draw_Strings();
void  Block_Type();
void  Draw_Words();
void  Draw_Info();
void  Draw_Block();
void  Draw_Map();

void  Draw_Pointers();
void  Draw_Offset();
void  Word_Pointers();
void  Block_Pointers();
void  Map_Pointers();

void  Print_Number();
void  Print_Ascii();
void  Warning();


/*  de_diskio.c  */

void  Read_Disk();
void  Read_Block();
void  Read_Super_Block();
void  Read_Bit_Maps();
off_t Search();
void  Write_Word();


/*  de_recover.c  */

int   Path_Dir_File();
char *File_Device();
ino_t Find_Deleted_Entry();
off_t Recover_Blocks();


#undef    printf			/*  Because fs/const.h	*/
					/*  defines it.		*/
